/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.VWSIMWorkflowDialog;
import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWSIMImportWorkflowDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener,
ActionListener {
    protected static final int CHOICE_LOCAL = 0;
    protected static final int CHOICE_IDM = 1;
    protected static final int CHOICE_SERVER = 2;
    protected static final String DEFAULT_FILE_MASK = "*.pep; *.xpdl";
    protected JRadioButton m_localRadioButton = null;
    protected JRadioButton m_idmRadioButton = null;
    protected JRadioButton m_serverRadioButton = null;
    protected VWDialogButtons m_dlgButtons = null;
    protected FileDialog m_localOpenDialog = null;
    protected VWWorkflowDefinition[] m_wflDefArray = null;
    protected VWSIMPropertyData m_propertyData = null;
    protected int m_nChoice = 0;
    private JCheckBox m_replaceInitFieldValuesChkBox = null;

    public VWSIMImportWorkflowDialog(VWSIMPropertyData propertyData) {
        super(propertyData.getParentFrame());
        this.m_propertyData = propertyData;
        this.init();
    }

    public VWWorkflowDefinition[] getWorkflowDefinitions() {
        if (this.m_wflDefArray != null && this.m_wflDefArray.length > 0) {
            VWWorkflowDefinition[] wflDefs = new VWWorkflowDefinition[this.m_wflDefArray.length];
            System.arraycopy(this.m_wflDefArray, 0, wflDefs, 0, this.m_wflDefArray.length);
            return wflDefs;
        }
        return null;
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.performOKAction();
                break;
            }
            case 2: {
                this.performCancelAction();
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_localRadioButton) {
            this.m_nChoice = 0;
        } else if (src == this.m_idmRadioButton) {
            this.m_nChoice = 1;
        } else if (src == this.m_serverRadioButton) {
            this.m_nChoice = 2;
        } else if (src == this.m_replaceInitFieldValuesChkBox && this.m_replaceInitFieldValuesChkBox != null) {
            this.m_propertyData.setReplaceInitialDataFields(this.m_replaceInitFieldValuesChkBox.isSelected());
        }
    }

    protected void init() {
        try {
            this.setTitle(VWSIMResource.s_importWorkflow);
            Dimension dim = VWStringUtils.stringToDimension("315,175");
            if (dim != null) {
                this.setSize(dim);
            }
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)this.getMainPanel(VWSIMResource.s_importWorkflowFrom, false), "Center");
            this.m_dlgButtons = new VWDialogButtons(35);
            this.m_dlgButtons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)this.m_dlgButtons, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getMainPanel(String mainLabel, boolean bAddReplace) {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 10, 5);
            mainPanel.add((Component)new JLabel(mainLabel), gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 35, 0, 15);
            this.m_localRadioButton = new JRadioButton(VWSIMResource.s_localStorage);
            this.m_localRadioButton.setSelected(true);
            this.m_localRadioButton.addActionListener(this);
            buttonGroup.add(this.m_localRadioButton);
            mainPanel.add((Component)this.m_localRadioButton, gbCons);
            ++gbCons.gridy;
            this.m_idmRadioButton = new JRadioButton(VWIDMBaseFactory.instance().getVWString(16).toString());
            this.m_idmRadioButton.setSelected(false);
            this.m_idmRadioButton.addActionListener(this);
            buttonGroup.add(this.m_idmRadioButton);
            mainPanel.add((Component)this.m_idmRadioButton, gbCons);
            ++gbCons.gridy;
            this.m_serverRadioButton = new JRadioButton(VWSIMResource.s_processEngine);
            this.m_serverRadioButton.setSelected(false);
            this.m_serverRadioButton.addActionListener(this);
            buttonGroup.add(this.m_serverRadioButton);
            mainPanel.add((Component)this.m_serverRadioButton, gbCons);
            if (bAddReplace) {
                ++gbCons.gridy;
                gbCons.insets = new Insets(10, 5, 10, 5);
                this.m_replaceInitFieldValuesChkBox = new JCheckBox(VWSIMResource.s_replaceInitialDataFields, false);
                this.m_replaceInitFieldValuesChkBox.addActionListener(this);
                mainPanel.add((Component)this.m_replaceInitFieldValuesChkBox, gbCons);
            }
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void performOKAction() {
        this.setVisible(false);
        switch (this.m_nChoice) {
            case 0: {
                this.openLocalWorkflow();
                break;
            }
            case 1: {
                this.openIDMWorkflow();
                break;
            }
            case 2: {
                this.openServerWorkflow();
            }
        }
        if (this.m_replaceInitFieldValuesChkBox != null) {
            this.m_propertyData.setReplaceInitialDataFields(this.m_replaceInitFieldValuesChkBox.isSelected());
        }
        this.m_nExitStatus = 0;
    }

    protected void performCancelAction() {
        this.m_nExitStatus = 1;
        this.setVisible(false);
    }

    protected void performHelpAction() {
        VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "vwsimimportworkflowdialog.htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLocalWorkflow() {
        block8: {
            if (this.m_localOpenDialog == null) {
                this.m_localOpenDialog = new FileDialog(this.m_propertyData.getParentFrame());
                this.m_localOpenDialog.setTitle(VWSIMResource.s_importWorkflow);
                this.m_localOpenDialog.setFile(DEFAULT_FILE_MASK);
            }
            this.m_localOpenDialog.setVisible(true);
            String dir = this.m_localOpenDialog.getDirectory();
            String file = this.m_localOpenDialog.getFile();
            if (file != null) {
                String path = dir + file;
                try {
                    block7: {
                        try {
                            this.m_propertyData.displayWaitCursor();
                            FileInputStream stream = new FileInputStream(path);
                            VWWorkflowCollectionDefinition wflCollectionDef = VWWorkflowCollectionDefinition.read(stream);
                            stream.close();
                            if (wflCollectionDef == null) break block7;
                            this.m_wflDefArray = wflCollectionDef.getWorkflows();
                        }
                        catch (IOException ex) {
                            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                            Object var7_9 = null;
                            this.m_propertyData.restoreDefaultCursor();
                            break block8;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            Object var7_10 = null;
                            this.m_propertyData.restoreDefaultCursor();
                        }
                    }
                    Object var7_8 = null;
                    this.m_propertyData.restoreDefaultCursor();
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.m_propertyData.restoreDefaultCursor();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIDMWorkflow() {
        block9: {
            try {
                try {
                    this.m_propertyData.displayWaitCursor();
                    String[] resources = VWStringUtils.getResourcesFromString(VWSIMResource.s_select_withHK);
                    IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(this.m_propertyData.getIDMContext(), 17, resources[0], null, "WorkflowDefinition");
                    dialog.setTitle(VWIDMBaseFactory.instance().getVWString(21).toString());
                    dialog.setButtonMnemonic(resources[1]);
                    dialog.setButtonTooltip(VWSIMResource.s_select);
                    this.m_propertyData.restoreDefaultCursor();
                    switch (dialog.showDialog(this.m_propertyData.getParentFrame())) {
                        case 0: {
                            IVWIDMDocument doc = (IVWIDMDocument)dialog.getSelectedItem();
                            if (doc == null) break;
                            this.m_propertyData.setIDMContext(doc);
                            this.m_propertyData.displayWaitCursor();
                            byte[] fileContents = doc.getContents(false);
                            ByteArrayInputStream inStream = new ByteArrayInputStream(fileContents);
                            VWWorkflowCollectionDefinition wflCollectionDef = VWWorkflowCollectionDefinition.read(inStream);
                            inStream.close();
                            if (wflCollectionDef != null) {
                                this.m_wflDefArray = wflCollectionDef.getWorkflows();
                            }
                            this.m_propertyData.restoreDefaultCursor();
                            break;
                        }
                    }
                }
                catch (VWException ex) {
                    VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                    Object var8_10 = null;
                    this.m_propertyData.restoreDefaultCursor();
                    break block9;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var8_11 = null;
                    this.m_propertyData.restoreDefaultCursor();
                }
                Object var8_9 = null;
                this.m_propertyData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.m_propertyData.restoreDefaultCursor();
                throw throwable;
            }
        }
    }

    private void openServerWorkflow() {
        try {
            if (this.m_propertyData.getVWSession() != null) {
                VWSIMWorkflowDialog wfDialog = new VWSIMWorkflowDialog(this.m_propertyData.getParentFrame(), this.m_propertyData.getVWSession());
                wfDialog.setVisible(true);
                switch (wfDialog.getExitStatus()) {
                    case 0: {
                        this.m_wflDefArray = wfDialog.getWorkflowDefinitions();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

